/******************************************************************************
** Copyright (C) 2006-2015 ascolab GmbH. All Rights Reserved.
** Web: http://www.ascolab.com
**
** SPDX-License-Identifier: GPL-2.0-or-later
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** Project: OpcUa Wireshark Plugin
**
** Description: OpcUa Complex Type Parser
**
** This file was autogenerated on 13.10.2015.
** DON'T MODIFY THIS FILE!
**
******************************************************************************/

#include "config.h"

#include <epan/packet.h>
#include "opcua_complextypeparser.h"
#include "opcua_enumparser.h"
#include "opcua_simpletypes.h"
#include "opcua_hfindeces.h"
#include "opcua_serviceparser.h"

int ett_opcua_ServiceFault;
int ett_opcua_array_ServiceFault;
int ett_opcua_FindServersRequest;
int ett_opcua_array_FindServersRequest;
int ett_opcua_FindServersResponse;
int ett_opcua_array_FindServersResponse;
int ett_opcua_FindServersOnNetworkRequest;
int ett_opcua_array_FindServersOnNetworkRequest;
int ett_opcua_FindServersOnNetworkResponse;
int ett_opcua_array_FindServersOnNetworkResponse;
int ett_opcua_GetEndpointsRequest;
int ett_opcua_array_GetEndpointsRequest;
int ett_opcua_GetEndpointsResponse;
int ett_opcua_array_GetEndpointsResponse;
int ett_opcua_RegisterServerRequest;
int ett_opcua_array_RegisterServerRequest;
int ett_opcua_RegisterServerResponse;
int ett_opcua_array_RegisterServerResponse;
int ett_opcua_RegisterServer2Request;
int ett_opcua_array_RegisterServer2Request;
int ett_opcua_RegisterServer2Response;
int ett_opcua_array_RegisterServer2Response;
int ett_opcua_OpenSecureChannelRequest;
int ett_opcua_array_OpenSecureChannelRequest;
int ett_opcua_OpenSecureChannelResponse;
int ett_opcua_array_OpenSecureChannelResponse;
int ett_opcua_CloseSecureChannelRequest;
int ett_opcua_array_CloseSecureChannelRequest;
int ett_opcua_CloseSecureChannelResponse;
int ett_opcua_array_CloseSecureChannelResponse;
int ett_opcua_CreateSessionRequest;
int ett_opcua_array_CreateSessionRequest;
int ett_opcua_CreateSessionResponse;
int ett_opcua_array_CreateSessionResponse;
int ett_opcua_ActivateSessionRequest;
int ett_opcua_array_ActivateSessionRequest;
int ett_opcua_ActivateSessionResponse;
int ett_opcua_array_ActivateSessionResponse;
int ett_opcua_CloseSessionRequest;
int ett_opcua_array_CloseSessionRequest;
int ett_opcua_CloseSessionResponse;
int ett_opcua_array_CloseSessionResponse;
int ett_opcua_CancelRequest;
int ett_opcua_array_CancelRequest;
int ett_opcua_CancelResponse;
int ett_opcua_array_CancelResponse;
int ett_opcua_AddNodesRequest;
int ett_opcua_array_AddNodesRequest;
int ett_opcua_AddNodesResponse;
int ett_opcua_array_AddNodesResponse;
int ett_opcua_AddReferencesRequest;
int ett_opcua_array_AddReferencesRequest;
int ett_opcua_AddReferencesResponse;
int ett_opcua_array_AddReferencesResponse;
int ett_opcua_DeleteNodesRequest;
int ett_opcua_array_DeleteNodesRequest;
int ett_opcua_DeleteNodesResponse;
int ett_opcua_array_DeleteNodesResponse;
int ett_opcua_DeleteReferencesRequest;
int ett_opcua_array_DeleteReferencesRequest;
int ett_opcua_DeleteReferencesResponse;
int ett_opcua_array_DeleteReferencesResponse;
int ett_opcua_BrowseRequest;
int ett_opcua_array_BrowseRequest;
int ett_opcua_BrowseResponse;
int ett_opcua_array_BrowseResponse;
int ett_opcua_BrowseNextRequest;
int ett_opcua_array_BrowseNextRequest;
int ett_opcua_BrowseNextResponse;
int ett_opcua_array_BrowseNextResponse;
int ett_opcua_TranslateBrowsePathsToNodeIdsRequest;
int ett_opcua_array_TranslateBrowsePathsToNodeIdsRequest;
int ett_opcua_TranslateBrowsePathsToNodeIdsResponse;
int ett_opcua_array_TranslateBrowsePathsToNodeIdsResponse;
int ett_opcua_RegisterNodesRequest;
int ett_opcua_array_RegisterNodesRequest;
int ett_opcua_RegisterNodesResponse;
int ett_opcua_array_RegisterNodesResponse;
int ett_opcua_UnregisterNodesRequest;
int ett_opcua_array_UnregisterNodesRequest;
int ett_opcua_UnregisterNodesResponse;
int ett_opcua_array_UnregisterNodesResponse;
int ett_opcua_QueryFirstRequest;
int ett_opcua_array_QueryFirstRequest;
int ett_opcua_QueryFirstResponse;
int ett_opcua_array_QueryFirstResponse;
int ett_opcua_QueryNextRequest;
int ett_opcua_array_QueryNextRequest;
int ett_opcua_QueryNextResponse;
int ett_opcua_array_QueryNextResponse;
int ett_opcua_ReadRequest;
int ett_opcua_array_ReadRequest;
int ett_opcua_ReadResponse;
int ett_opcua_array_ReadResponse;
int ett_opcua_HistoryReadRequest;
int ett_opcua_array_HistoryReadRequest;
int ett_opcua_HistoryReadResponse;
int ett_opcua_array_HistoryReadResponse;
int ett_opcua_WriteRequest;
int ett_opcua_array_WriteRequest;
int ett_opcua_WriteResponse;
int ett_opcua_array_WriteResponse;
int ett_opcua_HistoryUpdateRequest;
int ett_opcua_array_HistoryUpdateRequest;
int ett_opcua_HistoryUpdateResponse;
int ett_opcua_array_HistoryUpdateResponse;
int ett_opcua_CallRequest;
int ett_opcua_array_CallRequest;
int ett_opcua_CallResponse;
int ett_opcua_array_CallResponse;
int ett_opcua_CreateMonitoredItemsRequest;
int ett_opcua_array_CreateMonitoredItemsRequest;
int ett_opcua_CreateMonitoredItemsResponse;
int ett_opcua_array_CreateMonitoredItemsResponse;
int ett_opcua_ModifyMonitoredItemsRequest;
int ett_opcua_array_ModifyMonitoredItemsRequest;
int ett_opcua_ModifyMonitoredItemsResponse;
int ett_opcua_array_ModifyMonitoredItemsResponse;
int ett_opcua_SetMonitoringModeRequest;
int ett_opcua_array_SetMonitoringModeRequest;
int ett_opcua_SetMonitoringModeResponse;
int ett_opcua_array_SetMonitoringModeResponse;
int ett_opcua_SetTriggeringRequest;
int ett_opcua_array_SetTriggeringRequest;
int ett_opcua_SetTriggeringResponse;
int ett_opcua_array_SetTriggeringResponse;
int ett_opcua_DeleteMonitoredItemsRequest;
int ett_opcua_array_DeleteMonitoredItemsRequest;
int ett_opcua_DeleteMonitoredItemsResponse;
int ett_opcua_array_DeleteMonitoredItemsResponse;
int ett_opcua_CreateSubscriptionRequest;
int ett_opcua_array_CreateSubscriptionRequest;
int ett_opcua_CreateSubscriptionResponse;
int ett_opcua_array_CreateSubscriptionResponse;
int ett_opcua_ModifySubscriptionRequest;
int ett_opcua_array_ModifySubscriptionRequest;
int ett_opcua_ModifySubscriptionResponse;
int ett_opcua_array_ModifySubscriptionResponse;
int ett_opcua_SetPublishingModeRequest;
int ett_opcua_array_SetPublishingModeRequest;
int ett_opcua_SetPublishingModeResponse;
int ett_opcua_array_SetPublishingModeResponse;
int ett_opcua_PublishRequest;
int ett_opcua_array_PublishRequest;
int ett_opcua_PublishResponse;
int ett_opcua_array_PublishResponse;
int ett_opcua_RepublishRequest;
int ett_opcua_array_RepublishRequest;
int ett_opcua_RepublishResponse;
int ett_opcua_array_RepublishResponse;
int ett_opcua_TransferSubscriptionsRequest;
int ett_opcua_array_TransferSubscriptionsRequest;
int ett_opcua_TransferSubscriptionsResponse;
int ett_opcua_array_TransferSubscriptionsResponse;
int ett_opcua_DeleteSubscriptionsRequest;
int ett_opcua_array_DeleteSubscriptionsRequest;
int ett_opcua_DeleteSubscriptionsResponse;
int ett_opcua_array_DeleteSubscriptionsResponse;
int ett_opcua_TestStackRequest;
int ett_opcua_array_TestStackRequest;
int ett_opcua_TestStackResponse;
int ett_opcua_array_TestStackResponse;
int ett_opcua_TestStackExRequest;
int ett_opcua_array_TestStackExRequest;
int ett_opcua_TestStackExResponse;
int ett_opcua_array_TestStackExResponse;

void parseServiceFault(proto_tree *tree, tvbuff_t *tvb, packet_info *pinfo, int *pOffset)
{
  proto_item *ti;
  proto_tree *subtree = proto_tree_add_subtree(tree, tvb, *pOffset, -1, ett_opcua_ServiceFault, &ti, "ServiceFault");

  parseResponseHeader(subtree, tvb, pinfo, pOffset, "ResponseHeader");
  proto_item_set_end(ti, tvb, *pOffset);
}
void parseFindServersRequest(proto_tree *tree, tvbuff_t *tvb, packet_info *pinfo, int *pOffset)
{
  proto_item *ti;
  proto_tree *subtree = proto_tree_add_subtree(tree, tvb, *pOffset, -1, ett_opcua_FindServersRequest, &ti, "FindServersRequest");

  parseRequestHeader(subtree, tvb, pinfo, pOffset, "RequestHeader");
  parseString(subtree, tvb, pinfo, pOffset, hf_opcua_EndpointUrl);
  /* Array length field ignored: NoOfLocaleIds */
  parseArraySimple(subtree, tvb, pinfo, pOffset, "LocaleIds", "String", hf_opcua_LocaleIds, parseString, ett_opcua_array_String);
  /* Array length field ignored: NoOfServerUris */
  parseArraySimple(subtree, tvb, pinfo, pOffset, "ServerUris", "String", hf_opcua_ServerUris, parseString, ett_opcua_array_String);
  proto_item_set_end(ti, tvb, *pOffset);
}
void parseFindServersResponse(proto_tree *tree, tvbuff_t *tvb, packet_info *pinfo, int *pOffset)
{
  proto_item *ti;
  proto_tree *subtree = proto_tree_add_subtree(tree, tvb, *pOffset, -1, ett_opcua_FindServersResponse, &ti, "FindServersResponse");

  parseResponseHeader(subtree, tvb, pinfo, pOffset, "ResponseHeader");
  /* Array length field ignored: NoOfServers */
  parseArrayComplex(subtree, tvb, pinfo, pOffset, "Servers", "ApplicationDescription", parseApplicationDescription, ett_opcua_array_ApplicationDescription);
  proto_item_set_end(ti, tvb, *pOffset);
}
void parseFindServersOnNetworkRequest(proto_tree *tree, tvbuff_t *tvb, packet_info *pinfo, int *pOffset)
{
  proto_item *ti;
  proto_tree *subtree = proto_tree_add_subtree(tree, tvb, *pOffset, -1, ett_opcua_FindServersOnNetworkRequest, &ti, "FindServersOnNetworkRequest");

  parseRequestHeader(subtree, tvb, pinfo, pOffset, "RequestHeader");
  parseUInt32(subtree, tvb, pinfo, pOffset, hf_opcua_StartingRecordId);
  parseUInt32(subtree, tvb, pinfo, pOffset, hf_opcua_MaxRecordsToReturn);
  /* Array length field ignored: NoOfServerCapabilityFilter */
  parseArraySimple(subtree, tvb, pinfo, pOffset, "ServerCapabilityFilter", "String", hf_opcua_ServerCapabilityFilter, parseString, ett_opcua_array_String);
  proto_item_set_end(ti, tvb, *pOffset);
}
void parseFindServersOnNetworkResponse(proto_tree *tree, tvbuff_t *tvb, packet_info *pinfo, int *pOffset)
{
  proto_item *ti;
  proto_tree *subtree = proto_tree_add_subtree(tree, tvb, *pOffset, -1, ett_opcua_FindServersOnNetworkResponse, &ti, "FindServersOnNetworkResponse");

  parseResponseHeader(subtree, tvb, pinfo, pOffset, "ResponseHeader");
  parseDateTime(subtree, tvb, pinfo, pOffset, hf_opcua_LastCounterResetTime);
  /* Array length field ignored: NoOfServers */
  parseArrayComplex(subtree, tvb, pinfo, pOffset, "Servers", "ServerOnNetwork", parseServerOnNetwork, ett_opcua_array_ServerOnNetwork);
  proto_item_set_end(ti, tvb, *pOffset);
}
void parseGetEndpointsRequest(proto_tree *tree, tvbuff_t *tvb, packet_info *pinfo, int *pOffset)
{
  proto_item *ti;
  proto_tree *subtree = proto_tree_add_subtree(tree, tvb, *pOffset, -1, ett_opcua_GetEndpointsRequest, &ti, "GetEndpointsRequest");

  parseRequestHeader(subtree, tvb, pinfo, pOffset, "RequestHeader");
  parseString(subtree, tvb, pinfo, pOffset, hf_opcua_EndpointUrl);
  /* Array length field ignored: NoOfLocaleIds */
  parseArraySimple(subtree, tvb, pinfo, pOffset, "LocaleIds", "String", hf_opcua_LocaleIds, parseString, ett_opcua_array_String);
  /* Array length field ignored: NoOfProfileUris */
  parseArraySimple(subtree, tvb, pinfo, pOffset, "ProfileUris", "String", hf_opcua_ProfileUris, parseString, ett_opcua_array_String);
  proto_item_set_end(ti, tvb, *pOffset);
}
void parseGetEndpointsResponse(proto_tree *tree, tvbuff_t *tvb, packet_info *pinfo, int *pOffset)
{
  proto_item *ti;
  proto_tree *subtree = proto_tree_add_subtree(tree, tvb, *pOffset, -1, ett_opcua_GetEndpointsResponse, &ti, "GetEndpointsResponse");

  parseResponseHeader(subtree, tvb, pinfo, pOffset, "ResponseHeader");
  /* Array length field ignored: NoOfEndpoints */
  parseArrayComplex(subtree, tvb, pinfo, pOffset, "Endpoints", "EndpointDescription", parseEndpointDescription, ett_opcua_array_EndpointDescription);
  proto_item_set_end(ti, tvb, *pOffset);
}
void parseRegisterServerRequest(proto_tree *tree, tvbuff_t *tvb, packet_info *pinfo, int *pOffset)
{
  proto_item *ti;
  proto_tree *subtree = proto_tree_add_subtree(tree, tvb, *pOffset, -1, ett_opcua_RegisterServerRequest, &ti, "RegisterServerRequest");

  parseRequestHeader(subtree, tvb, pinfo, pOffset, "RequestHeader");
  parseRegisteredServer(subtree, tvb, pinfo, pOffset, "Server");
  proto_item_set_end(ti, tvb, *pOffset);
}
void parseRegisterServerResponse(proto_tree *tree, tvbuff_t *tvb, packet_info *pinfo, int *pOffset)
{
  proto_item *ti;
  proto_tree *subtree = proto_tree_add_subtree(tree, tvb, *pOffset, -1, ett_opcua_RegisterServerResponse, &ti, "RegisterServerResponse");

  parseResponseHeader(subtree, tvb, pinfo, pOffset, "ResponseHeader");
  proto_item_set_end(ti, tvb, *pOffset);
}
void parseRegisterServer2Request(proto_tree *tree, tvbuff_t *tvb, packet_info *pinfo, int *pOffset)
{
  proto_item *ti;
  proto_tree *subtree = proto_tree_add_subtree(tree, tvb, *pOffset, -1, ett_opcua_RegisterServer2Request, &ti, "RegisterServer2Request");

  parseRequestHeader(subtree, tvb, pinfo, pOffset, "RequestHeader");
  parseRegisteredServer(subtree, tvb, pinfo, pOffset, "Server");
  /* Array length field ignored: NoOfDiscoveryConfiguration */
  parseArrayComplex(subtree, tvb, pinfo, pOffset, "DiscoveryConfiguration", "ExtensionObject", parseExtensionObject, ett_opcua_array_ExtensionObject);
  proto_item_set_end(ti, tvb, *pOffset);
}
void parseRegisterServer2Response(proto_tree *tree, tvbuff_t *tvb, packet_info *pinfo, int *pOffset)
{
  proto_item *ti;
  proto_tree *subtree = proto_tree_add_subtree(tree, tvb, *pOffset, -1, ett_opcua_RegisterServer2Response, &ti, "RegisterServer2Response");

  parseResponseHeader(subtree, tvb, pinfo, pOffset, "ResponseHeader");
  /* Array length field ignored: NoOfConfigurationResults */
  parseArraySimple(subtree, tvb, pinfo, pOffset, "ConfigurationResults", "StatusCode", hf_opcua_ConfigurationResults, parseStatusCode, ett_opcua_array_StatusCode);
  /* Array length field ignored: NoOfDiagnosticInfos */
  parseArrayComplex(subtree, tvb, pinfo, pOffset, "DiagnosticInfos", "DiagnosticInfo", parseDiagnosticInfo, ett_opcua_array_DiagnosticInfo);
  proto_item_set_end(ti, tvb, *pOffset);
}
void parseOpenSecureChannelRequest(proto_tree *tree, tvbuff_t *tvb, packet_info *pinfo, int *pOffset)
{
  proto_item *ti;
  proto_tree *subtree = proto_tree_add_subtree(tree, tvb, *pOffset, -1, ett_opcua_OpenSecureChannelRequest, &ti, "OpenSecureChannelRequest");

  parseRequestHeader(subtree, tvb, pinfo, pOffset, "RequestHeader");
  parseUInt32(subtree, tvb, pinfo, pOffset, hf_opcua_ClientProtocolVersion);
  parseSecurityTokenRequestType(subtree, tvb, pinfo, pOffset);
  parseMessageSecurityMode(subtree, tvb, pinfo, pOffset);
  parseByteString(subtree, tvb, pinfo, pOffset, hf_opcua_ClientNonce);
  parseUInt32(subtree, tvb, pinfo, pOffset, hf_opcua_RequestedLifetime);
  proto_item_set_end(ti, tvb, *pOffset);
}
void parseOpenSecureChannelResponse(proto_tree *tree, tvbuff_t *tvb, packet_info *pinfo, int *pOffset)
{
  proto_item *ti;
  proto_tree *subtree = proto_tree_add_subtree(tree, tvb, *pOffset, -1, ett_opcua_OpenSecureChannelResponse, &ti, "OpenSecureChannelResponse");

  parseResponseHeader(subtree, tvb, pinfo, pOffset, "ResponseHeader");
  parseUInt32(subtree, tvb, pinfo, pOffset, hf_opcua_ServerProtocolVersion);
  parseChannelSecurityToken(subtree, tvb, pinfo, pOffset, "SecurityToken");
  parseByteString(subtree, tvb, pinfo, pOffset, hf_opcua_ServerNonce);
  proto_item_set_end(ti, tvb, *pOffset);
}
void parseCloseSecureChannelRequest(proto_tree *tree, tvbuff_t *tvb, packet_info *pinfo, int *pOffset)
{
  proto_item *ti;
  proto_tree *subtree = proto_tree_add_subtree(tree, tvb, *pOffset, -1, ett_opcua_CloseSecureChannelRequest, &ti, "CloseSecureChannelRequest");

  parseRequestHeader(subtree, tvb, pinfo, pOffset, "RequestHeader");
  proto_item_set_end(ti, tvb, *pOffset);
}
void parseCloseSecureChannelResponse(proto_tree *tree, tvbuff_t *tvb, packet_info *pinfo, int *pOffset)
{
  proto_item *ti;
  proto_tree *subtree = proto_tree_add_subtree(tree, tvb, *pOffset, -1, ett_opcua_CloseSecureChannelResponse, &ti, "CloseSecureChannelResponse");

  parseResponseHeader(subtree, tvb, pinfo, pOffset, "ResponseHeader");
  proto_item_set_end(ti, tvb, *pOffset);
}
void parseCreateSessionRequest(proto_tree *tree, tvbuff_t *tvb, packet_info *pinfo, int *pOffset)
{
  proto_item *ti;
  proto_tree *subtree = proto_tree_add_subtree(tree, tvb, *pOffset, -1, ett_opcua_CreateSessionRequest, &ti, "CreateSessionRequest");

  parseRequestHeader(subtree, tvb, pinfo, pOffset, "RequestHeader");
  parseApplicationDescription(subtree, tvb, pinfo, pOffset, "ClientDescription");
  parseString(subtree, tvb, pinfo, pOffset, hf_opcua_ServerUri);
  parseString(subtree, tvb, pinfo, pOffset, hf_opcua_EndpointUrl);
  parseString(subtree, tvb, pinfo, pOffset, hf_opcua_SessionName);
  parseByteString(subtree, tvb, pinfo, pOffset, hf_opcua_ClientNonce);
  parseCertificate(subtree, tvb, pinfo, pOffset, hf_opcua_ClientCertificate);
  parseDouble(subtree, tvb, pinfo, pOffset, hf_opcua_RequestedSessionTimeout);
  parseUInt32(subtree, tvb, pinfo, pOffset, hf_opcua_MaxResponseMessageSize);
  proto_item_set_end(ti, tvb, *pOffset);
}
void parseCreateSessionResponse(proto_tree *tree, tvbuff_t *tvb, packet_info *pinfo, int *pOffset)
{
  proto_item *ti;
  proto_tree *subtree = proto_tree_add_subtree(tree, tvb, *pOffset, -1, ett_opcua_CreateSessionResponse, &ti, "CreateSessionResponse");

  parseResponseHeader(subtree, tvb, pinfo, pOffset, "ResponseHeader");
  parseNodeId(subtree, tvb, pinfo, pOffset, "SessionId");
  parseNodeId(subtree, tvb, pinfo, pOffset, "AuthenticationToken");
  parseDouble(subtree, tvb, pinfo, pOffset, hf_opcua_RevisedSessionTimeout);
  parseByteString(subtree, tvb, pinfo, pOffset, hf_opcua_ServerNonce);
  parseCertificate(subtree, tvb, pinfo, pOffset, hf_opcua_ServerCertificate);
  /* Array length field ignored: NoOfServerEndpoints */
  parseArrayComplex(subtree, tvb, pinfo, pOffset, "ServerEndpoints", "EndpointDescription", parseEndpointDescription, ett_opcua_array_EndpointDescription);
  /* Array length field ignored: NoOfServerSoftwareCertificates */
  parseArrayComplex(subtree, tvb, pinfo, pOffset, "ServerSoftwareCertificates", "SignedSoftwareCertificate", parseSignedSoftwareCertificate, ett_opcua_array_SignedSoftwareCertificate);
  parseSignatureData(subtree, tvb, pinfo, pOffset, "ServerSignature");
  parseUInt32(subtree, tvb, pinfo, pOffset, hf_opcua_MaxRequestMessageSize);
  proto_item_set_end(ti, tvb, *pOffset);
}
void parseActivateSessionRequest(proto_tree *tree, tvbuff_t *tvb, packet_info *pinfo, int *pOffset)
{
  proto_item *ti;
  proto_tree *subtree = proto_tree_add_subtree(tree, tvb, *pOffset, -1, ett_opcua_ActivateSessionRequest, &ti, "ActivateSessionRequest");

  parseRequestHeader(subtree, tvb, pinfo, pOffset, "RequestHeader");
  parseSignatureData(subtree, tvb, pinfo, pOffset, "ClientSignature");
  /* Array length field ignored: NoOfClientSoftwareCertificates */
  parseArrayComplex(subtree, tvb, pinfo, pOffset, "ClientSoftwareCertificates", "SignedSoftwareCertificate", parseSignedSoftwareCertificate, ett_opcua_array_SignedSoftwareCertificate);
  /* Array length field ignored: NoOfLocaleIds */
  parseArraySimple(subtree, tvb, pinfo, pOffset, "LocaleIds", "String", hf_opcua_LocaleIds, parseString, ett_opcua_array_String);
  parseExtensionObject(subtree, tvb, pinfo, pOffset, "UserIdentityToken");
  parseSignatureData(subtree, tvb, pinfo, pOffset, "UserTokenSignature");
  proto_item_set_end(ti, tvb, *pOffset);
}
void parseActivateSessionResponse(proto_tree *tree, tvbuff_t *tvb, packet_info *pinfo, int *pOffset)
{
  proto_item *ti;
  proto_tree *subtree = proto_tree_add_subtree(tree, tvb, *pOffset, -1, ett_opcua_ActivateSessionResponse, &ti, "ActivateSessionResponse");

  parseResponseHeader(subtree, tvb, pinfo, pOffset, "ResponseHeader");
  parseByteString(subtree, tvb, pinfo, pOffset, hf_opcua_ServerNonce);
  /* Array length field ignored: NoOfResults */
  parseArraySimple(subtree, tvb, pinfo, pOffset, "Results", "StatusCode", hf_opcua_Results, parseStatusCode, ett_opcua_array_StatusCode);
  /* Array length field ignored: NoOfDiagnosticInfos */
  parseArrayComplex(subtree, tvb, pinfo, pOffset, "DiagnosticInfos", "DiagnosticInfo", parseDiagnosticInfo, ett_opcua_array_DiagnosticInfo);
  proto_item_set_end(ti, tvb, *pOffset);
}
void parseCloseSessionRequest(proto_tree *tree, tvbuff_t *tvb, packet_info *pinfo, int *pOffset)
{
  proto_item *ti;
  proto_tree *subtree = proto_tree_add_subtree(tree, tvb, *pOffset, -1, ett_opcua_CloseSessionRequest, &ti, "CloseSessionRequest");

  parseRequestHeader(subtree, tvb, pinfo, pOffset, "RequestHeader");
  parseBoolean(subtree, tvb, pinfo, pOffset, hf_opcua_DeleteSubscriptions);
  proto_item_set_end(ti, tvb, *pOffset);
}
void parseCloseSessionResponse(proto_tree *tree, tvbuff_t *tvb, packet_info *pinfo, int *pOffset)
{
  proto_item *ti;
  proto_tree *subtree = proto_tree_add_subtree(tree, tvb, *pOffset, -1, ett_opcua_CloseSessionResponse, &ti, "CloseSessionResponse");

  parseResponseHeader(subtree, tvb, pinfo, pOffset, "ResponseHeader");
  proto_item_set_end(ti, tvb, *pOffset);
}
void parseCancelRequest(proto_tree *tree, tvbuff_t *tvb, packet_info *pinfo, int *pOffset)
{
  proto_item *ti;
  proto_tree *subtree = proto_tree_add_subtree(tree, tvb, *pOffset, -1, ett_opcua_CancelRequest, &ti, "CancelRequest");

  parseRequestHeader(subtree, tvb, pinfo, pOffset, "RequestHeader");
  parseUInt32(subtree, tvb, pinfo, pOffset, hf_opcua_RequestHandle);
  proto_item_set_end(ti, tvb, *pOffset);
}
void parseCancelResponse(proto_tree *tree, tvbuff_t *tvb, packet_info *pinfo, int *pOffset)
{
  proto_item *ti;
  proto_tree *subtree = proto_tree_add_subtree(tree, tvb, *pOffset, -1, ett_opcua_CancelResponse, &ti, "CancelResponse");

  parseResponseHeader(subtree, tvb, pinfo, pOffset, "ResponseHeader");
  parseUInt32(subtree, tvb, pinfo, pOffset, hf_opcua_CancelCount);
  proto_item_set_end(ti, tvb, *pOffset);
}
void parseAddNodesRequest(proto_tree *tree, tvbuff_t *tvb, packet_info *pinfo, int *pOffset)
{
  proto_item *ti;
  proto_tree *subtree = proto_tree_add_subtree(tree, tvb, *pOffset, -1, ett_opcua_AddNodesRequest, &ti, "AddNodesRequest");

  parseRequestHeader(subtree, tvb, pinfo, pOffset, "RequestHeader");
  /* Array length field ignored: NoOfNodesToAdd */
  parseArrayComplex(subtree, tvb, pinfo, pOffset, "NodesToAdd", "AddNodesItem", parseAddNodesItem, ett_opcua_array_AddNodesItem);
  proto_item_set_end(ti, tvb, *pOffset);
}
void parseAddNodesResponse(proto_tree *tree, tvbuff_t *tvb, packet_info *pinfo, int *pOffset)
{
  proto_item *ti;
  proto_tree *subtree = proto_tree_add_subtree(tree, tvb, *pOffset, -1, ett_opcua_AddNodesResponse, &ti, "AddNodesResponse");

  parseResponseHeader(subtree, tvb, pinfo, pOffset, "ResponseHeader");
  /* Array length field ignored: NoOfResults */
  parseArrayComplex(subtree, tvb, pinfo, pOffset, "Results", "AddNodesResult", parseAddNodesResult, ett_opcua_array_AddNodesResult);
  /* Array length field ignored: NoOfDiagnosticInfos */
  parseArrayComplex(subtree, tvb, pinfo, pOffset, "DiagnosticInfos", "DiagnosticInfo", parseDiagnosticInfo, ett_opcua_array_DiagnosticInfo);
  proto_item_set_end(ti, tvb, *pOffset);
}
void parseAddReferencesRequest(proto_tree *tree, tvbuff_t *tvb, packet_info *pinfo, int *pOffset)
{
  proto_item *ti;
  proto_tree *subtree = proto_tree_add_subtree(tree, tvb, *pOffset, -1, ett_opcua_AddReferencesRequest, &ti, "AddReferencesRequest");

  parseRequestHeader(subtree, tvb, pinfo, pOffset, "RequestHeader");
  /* Array length field ignored: NoOfReferencesToAdd */
  parseArrayComplex(subtree, tvb, pinfo, pOffset, "ReferencesToAdd", "AddReferencesItem", parseAddReferencesItem, ett_opcua_array_AddReferencesItem);
  proto_item_set_end(ti, tvb, *pOffset);
}
void parseAddReferencesResponse(proto_tree *tree, tvbuff_t *tvb, packet_info *pinfo, int *pOffset)
{
  proto_item *ti;
  proto_tree *subtree = proto_tree_add_subtree(tree, tvb, *pOffset, -1, ett_opcua_AddReferencesResponse, &ti, "AddReferencesResponse");

  parseResponseHeader(subtree, tvb, pinfo, pOffset, "ResponseHeader");
  /* Array length field ignored: NoOfResults */
  parseArraySimple(subtree, tvb, pinfo, pOffset, "Results", "StatusCode", hf_opcua_Results, parseStatusCode, ett_opcua_array_StatusCode);
  /* Array length field ignored: NoOfDiagnosticInfos */
  parseArrayComplex(subtree, tvb, pinfo, pOffset, "DiagnosticInfos", "DiagnosticInfo", parseDiagnosticInfo, ett_opcua_array_DiagnosticInfo);
  proto_item_set_end(ti, tvb, *pOffset);
}
void parseDeleteNodesRequest(proto_tree *tree, tvbuff_t *tvb, packet_info *pinfo, int *pOffset)
{
  proto_item *ti;
  proto_tree *subtree = proto_tree_add_subtree(tree, tvb, *pOffset, -1, ett_opcua_DeleteNodesRequest, &ti, "DeleteNodesRequest");

  parseRequestHeader(subtree, tvb, pinfo, pOffset, "RequestHeader");
  /* Array length field ignored: NoOfNodesToDelete */
  parseArrayComplex(subtree, tvb, pinfo, pOffset, "NodesToDelete", "DeleteNodesItem", parseDeleteNodesItem, ett_opcua_array_DeleteNodesItem);
  proto_item_set_end(ti, tvb, *pOffset);
}
void parseDeleteNodesResponse(proto_tree *tree, tvbuff_t *tvb, packet_info *pinfo, int *pOffset)
{
  proto_item *ti;
  proto_tree *subtree = proto_tree_add_subtree(tree, tvb, *pOffset, -1, ett_opcua_DeleteNodesResponse, &ti, "DeleteNodesResponse");

  parseResponseHeader(subtree, tvb, pinfo, pOffset, "ResponseHeader");
  /* Array length field ignored: NoOfResults */
  parseArraySimple(subtree, tvb, pinfo, pOffset, "Results", "StatusCode", hf_opcua_Results, parseStatusCode, ett_opcua_array_StatusCode);
  /* Array length field ignored: NoOfDiagnosticInfos */
  parseArrayComplex(subtree, tvb, pinfo, pOffset, "DiagnosticInfos", "DiagnosticInfo", parseDiagnosticInfo, ett_opcua_array_DiagnosticInfo);
  proto_item_set_end(ti, tvb, *pOffset);
}
void parseDeleteReferencesRequest(proto_tree *tree, tvbuff_t *tvb, packet_info *pinfo, int *pOffset)
{
  proto_item *ti;
  proto_tree *subtree = proto_tree_add_subtree(tree, tvb, *pOffset, -1, ett_opcua_DeleteReferencesRequest, &ti, "DeleteReferencesRequest");

  parseRequestHeader(subtree, tvb, pinfo, pOffset, "RequestHeader");
  /* Array length field ignored: NoOfReferencesToDelete */
  parseArrayComplex(subtree, tvb, pinfo, pOffset, "ReferencesToDelete", "DeleteReferencesItem", parseDeleteReferencesItem, ett_opcua_array_DeleteReferencesItem);
  proto_item_set_end(ti, tvb, *pOffset);
}
void parseDeleteReferencesResponse(proto_tree *tree, tvbuff_t *tvb, packet_info *pinfo, int *pOffset)
{
  proto_item *ti;
  proto_tree *subtree = proto_tree_add_subtree(tree, tvb, *pOffset, -1, ett_opcua_DeleteReferencesResponse, &ti, "DeleteReferencesResponse");

  parseResponseHeader(subtree, tvb, pinfo, pOffset, "ResponseHeader");
  /* Array length field ignored: NoOfResults */
  parseArraySimple(subtree, tvb, pinfo, pOffset, "Results", "StatusCode", hf_opcua_Results, parseStatusCode, ett_opcua_array_StatusCode);
  /* Array length field ignored: NoOfDiagnosticInfos */
  parseArrayComplex(subtree, tvb, pinfo, pOffset, "DiagnosticInfos", "DiagnosticInfo", parseDiagnosticInfo, ett_opcua_array_DiagnosticInfo);
  proto_item_set_end(ti, tvb, *pOffset);
}
void parseBrowseRequest(proto_tree *tree, tvbuff_t *tvb, packet_info *pinfo, int *pOffset)
{
  proto_item *ti;
  proto_tree *subtree = proto_tree_add_subtree(tree, tvb, *pOffset, -1, ett_opcua_BrowseRequest, &ti, "BrowseRequest");

  parseRequestHeader(subtree, tvb, pinfo, pOffset, "RequestHeader");
  parseViewDescription(subtree, tvb, pinfo, pOffset, "View");
  parseUInt32(subtree, tvb, pinfo, pOffset, hf_opcua_RequestedMaxReferencesPerNode);
  /* Array length field ignored: NoOfNodesToBrowse */
  parseArrayComplex(subtree, tvb, pinfo, pOffset, "NodesToBrowse", "BrowseDescription", parseBrowseDescription, ett_opcua_array_BrowseDescription);
  proto_item_set_end(ti, tvb, *pOffset);
}
void parseBrowseResponse(proto_tree *tree, tvbuff_t *tvb, packet_info *pinfo, int *pOffset)
{
  proto_item *ti;
  proto_tree *subtree = proto_tree_add_subtree(tree, tvb, *pOffset, -1, ett_opcua_BrowseResponse, &ti, "BrowseResponse");

  parseResponseHeader(subtree, tvb, pinfo, pOffset, "ResponseHeader");
  /* Array length field ignored: NoOfResults */
  parseArrayComplex(subtree, tvb, pinfo, pOffset, "Results", "BrowseResult", parseBrowseResult, ett_opcua_array_BrowseResult);
  /* Array length field ignored: NoOfDiagnosticInfos */
  parseArrayComplex(subtree, tvb, pinfo, pOffset, "DiagnosticInfos", "DiagnosticInfo", parseDiagnosticInfo, ett_opcua_array_DiagnosticInfo);
  proto_item_set_end(ti, tvb, *pOffset);
}
void parseBrowseNextRequest(proto_tree *tree, tvbuff_t *tvb, packet_info *pinfo, int *pOffset)
{
  proto_item *ti;
  proto_tree *subtree = proto_tree_add_subtree(tree, tvb, *pOffset, -1, ett_opcua_BrowseNextRequest, &ti, "BrowseNextRequest");

  parseRequestHeader(subtree, tvb, pinfo, pOffset, "RequestHeader");
  parseBoolean(subtree, tvb, pinfo, pOffset, hf_opcua_ReleaseContinuationPoints);
  /* Array length field ignored: NoOfContinuationPoints */
  parseArraySimple(subtree, tvb, pinfo, pOffset, "ContinuationPoints", "ByteString", hf_opcua_ContinuationPoints, parseByteString, ett_opcua_array_ByteString);
  proto_item_set_end(ti, tvb, *pOffset);
}
void parseBrowseNextResponse(proto_tree *tree, tvbuff_t *tvb, packet_info *pinfo, int *pOffset)
{
  proto_item *ti;
  proto_tree *subtree = proto_tree_add_subtree(tree, tvb, *pOffset, -1, ett_opcua_BrowseNextResponse, &ti, "BrowseNextResponse");

  parseResponseHeader(subtree, tvb, pinfo, pOffset, "ResponseHeader");
  /* Array length field ignored: NoOfResults */
  parseArrayComplex(subtree, tvb, pinfo, pOffset, "Results", "BrowseResult", parseBrowseResult, ett_opcua_array_BrowseResult);
  /* Array length field ignored: NoOfDiagnosticInfos */
  parseArrayComplex(subtree, tvb, pinfo, pOffset, "DiagnosticInfos", "DiagnosticInfo", parseDiagnosticInfo, ett_opcua_array_DiagnosticInfo);
  proto_item_set_end(ti, tvb, *pOffset);
}
void parseTranslateBrowsePathsToNodeIdsRequest(proto_tree *tree, tvbuff_t *tvb, packet_info *pinfo, int *pOffset)
{
  proto_item *ti;
  proto_tree *subtree = proto_tree_add_subtree(tree, tvb, *pOffset, -1, ett_opcua_TranslateBrowsePathsToNodeIdsRequest, &ti, "TranslateBrowsePathsToNodeIdsRequest");

  parseRequestHeader(subtree, tvb, pinfo, pOffset, "RequestHeader");
  /* Array length field ignored: NoOfBrowsePaths */
  parseArrayComplex(subtree, tvb, pinfo, pOffset, "BrowsePaths", "BrowsePath", parseBrowsePath, ett_opcua_array_BrowsePath);
  proto_item_set_end(ti, tvb, *pOffset);
}
void parseTranslateBrowsePathsToNodeIdsResponse(proto_tree *tree, tvbuff_t *tvb, packet_info *pinfo, int *pOffset)
{
  proto_item *ti;
  proto_tree *subtree = proto_tree_add_subtree(tree, tvb, *pOffset, -1, ett_opcua_TranslateBrowsePathsToNodeIdsResponse, &ti, "TranslateBrowsePathsToNodeIdsResponse");

  parseResponseHeader(subtree, tvb, pinfo, pOffset, "ResponseHeader");
  /* Array length field ignored: NoOfResults */
  parseArrayComplex(subtree, tvb, pinfo, pOffset, "Results", "BrowsePathResult", parseBrowsePathResult, ett_opcua_array_BrowsePathResult);
  /* Array length field ignored: NoOfDiagnosticInfos */
  parseArrayComplex(subtree, tvb, pinfo, pOffset, "DiagnosticInfos", "DiagnosticInfo", parseDiagnosticInfo, ett_opcua_array_DiagnosticInfo);
  proto_item_set_end(ti, tvb, *pOffset);
}
void parseRegisterNodesRequest(proto_tree *tree, tvbuff_t *tvb, packet_info *pinfo, int *pOffset)
{
  proto_item *ti;
  proto_tree *subtree = proto_tree_add_subtree(tree, tvb, *pOffset, -1, ett_opcua_RegisterNodesRequest, &ti, "RegisterNodesRequest");

  parseRequestHeader(subtree, tvb, pinfo, pOffset, "RequestHeader");
  /* Array length field ignored: NoOfNodesToRegister */
  parseArrayComplex(subtree, tvb, pinfo, pOffset, "NodesToRegister", "NodeId", parseNodeId, ett_opcua_array_NodeId);
  proto_item_set_end(ti, tvb, *pOffset);
}
void parseRegisterNodesResponse(proto_tree *tree, tvbuff_t *tvb, packet_info *pinfo, int *pOffset)
{
  proto_item *ti;
  proto_tree *subtree = proto_tree_add_subtree(tree, tvb, *pOffset, -1, ett_opcua_RegisterNodesResponse, &ti, "RegisterNodesResponse");

  parseResponseHeader(subtree, tvb, pinfo, pOffset, "ResponseHeader");
  /* Array length field ignored: NoOfRegisteredNodeIds */
  parseArrayComplex(subtree, tvb, pinfo, pOffset, "RegisteredNodeIds", "NodeId", parseNodeId, ett_opcua_array_NodeId);
  proto_item_set_end(ti, tvb, *pOffset);
}
void parseUnregisterNodesRequest(proto_tree *tree, tvbuff_t *tvb, packet_info *pinfo, int *pOffset)
{
  proto_item *ti;
  proto_tree *subtree = proto_tree_add_subtree(tree, tvb, *pOffset, -1, ett_opcua_UnregisterNodesRequest, &ti, "UnregisterNodesRequest");

  parseRequestHeader(subtree, tvb, pinfo, pOffset, "RequestHeader");
  /* Array length field ignored: NoOfNodesToUnregister */
  parseArrayComplex(subtree, tvb, pinfo, pOffset, "NodesToUnregister", "NodeId", parseNodeId, ett_opcua_array_NodeId);
  proto_item_set_end(ti, tvb, *pOffset);
}
void parseUnregisterNodesResponse(proto_tree *tree, tvbuff_t *tvb, packet_info *pinfo, int *pOffset)
{
  proto_item *ti;
  proto_tree *subtree = proto_tree_add_subtree(tree, tvb, *pOffset, -1, ett_opcua_UnregisterNodesResponse, &ti, "UnregisterNodesResponse");

  parseResponseHeader(subtree, tvb, pinfo, pOffset, "ResponseHeader");
  proto_item_set_end(ti, tvb, *pOffset);
}
void parseQueryFirstRequest(proto_tree *tree, tvbuff_t *tvb, packet_info *pinfo, int *pOffset)
{
  proto_item *ti;
  proto_tree *subtree = proto_tree_add_subtree(tree, tvb, *pOffset, -1, ett_opcua_QueryFirstRequest, &ti, "QueryFirstRequest");

  parseRequestHeader(subtree, tvb, pinfo, pOffset, "RequestHeader");
  parseViewDescription(subtree, tvb, pinfo, pOffset, "View");
  /* Array length field ignored: NoOfNodeTypes */
  parseArrayComplex(subtree, tvb, pinfo, pOffset, "NodeTypes", "NodeTypeDescription", parseNodeTypeDescription, ett_opcua_array_NodeTypeDescription);
  parseContentFilter(subtree, tvb, pinfo, pOffset, "Filter");
  parseUInt32(subtree, tvb, pinfo, pOffset, hf_opcua_MaxDataSetsToReturn);
  parseUInt32(subtree, tvb, pinfo, pOffset, hf_opcua_MaxReferencesToReturn);
  proto_item_set_end(ti, tvb, *pOffset);
}
void parseQueryFirstResponse(proto_tree *tree, tvbuff_t *tvb, packet_info *pinfo, int *pOffset)
{
  proto_item *ti;
  proto_tree *subtree = proto_tree_add_subtree(tree, tvb, *pOffset, -1, ett_opcua_QueryFirstResponse, &ti, "QueryFirstResponse");

  parseResponseHeader(subtree, tvb, pinfo, pOffset, "ResponseHeader");
  /* Array length field ignored: NoOfQueryDataSets */
  parseArrayComplex(subtree, tvb, pinfo, pOffset, "QueryDataSets", "QueryDataSet", parseQueryDataSet, ett_opcua_array_QueryDataSet);
  parseByteString(subtree, tvb, pinfo, pOffset, hf_opcua_ContinuationPoint);
  /* Array length field ignored: NoOfParsingResults */
  parseArrayComplex(subtree, tvb, pinfo, pOffset, "ParsingResults", "ParsingResult", parseParsingResult, ett_opcua_array_ParsingResult);
  /* Array length field ignored: NoOfDiagnosticInfos */
  parseArrayComplex(subtree, tvb, pinfo, pOffset, "DiagnosticInfos", "DiagnosticInfo", parseDiagnosticInfo, ett_opcua_array_DiagnosticInfo);
  parseContentFilterResult(subtree, tvb, pinfo, pOffset, "FilterResult");
  proto_item_set_end(ti, tvb, *pOffset);
}
void parseQueryNextRequest(proto_tree *tree, tvbuff_t *tvb, packet_info *pinfo, int *pOffset)
{
  proto_item *ti;
  proto_tree *subtree = proto_tree_add_subtree(tree, tvb, *pOffset, -1, ett_opcua_QueryNextRequest, &ti, "QueryNextRequest");

  parseRequestHeader(subtree, tvb, pinfo, pOffset, "RequestHeader");
  parseBoolean(subtree, tvb, pinfo, pOffset, hf_opcua_ReleaseContinuationPoint);
  parseByteString(subtree, tvb, pinfo, pOffset, hf_opcua_ContinuationPoint);
  proto_item_set_end(ti, tvb, *pOffset);
}
void parseQueryNextResponse(proto_tree *tree, tvbuff_t *tvb, packet_info *pinfo, int *pOffset)
{
  proto_item *ti;
  proto_tree *subtree = proto_tree_add_subtree(tree, tvb, *pOffset, -1, ett_opcua_QueryNextResponse, &ti, "QueryNextResponse");

  parseResponseHeader(subtree, tvb, pinfo, pOffset, "ResponseHeader");
  /* Array length field ignored: NoOfQueryDataSets */
  parseArrayComplex(subtree, tvb, pinfo, pOffset, "QueryDataSets", "QueryDataSet", parseQueryDataSet, ett_opcua_array_QueryDataSet);
  parseByteString(subtree, tvb, pinfo, pOffset, hf_opcua_RevisedContinuationPoint);
  proto_item_set_end(ti, tvb, *pOffset);
}
void parseReadRequest(proto_tree *tree, tvbuff_t *tvb, packet_info *pinfo, int *pOffset)
{
  proto_item *ti;
  proto_tree *subtree = proto_tree_add_subtree(tree, tvb, *pOffset, -1, ett_opcua_ReadRequest, &ti, "ReadRequest");

  parseRequestHeader(subtree, tvb, pinfo, pOffset, "RequestHeader");
  parseDouble(subtree, tvb, pinfo, pOffset, hf_opcua_MaxAge);
  parseTimestampsToReturn(subtree, tvb, pinfo, pOffset);
  /* Array length field ignored: NoOfNodesToRead */
  parseArrayComplex(subtree, tvb, pinfo, pOffset, "NodesToRead", "ReadValueId", parseReadValueId, ett_opcua_array_ReadValueId);
  proto_item_set_end(ti, tvb, *pOffset);
}
void parseReadResponse(proto_tree *tree, tvbuff_t *tvb, packet_info *pinfo, int *pOffset)
{
  proto_item *ti;
  proto_tree *subtree = proto_tree_add_subtree(tree, tvb, *pOffset, -1, ett_opcua_ReadResponse, &ti, "ReadResponse");

  parseResponseHeader(subtree, tvb, pinfo, pOffset, "ResponseHeader");
  /* Array length field ignored: NoOfResults */
  parseArrayComplex(subtree, tvb, pinfo, pOffset, "Results", "DataValue", parseDataValue, ett_opcua_array_DataValue);
  /* Array length field ignored: NoOfDiagnosticInfos */
  parseArrayComplex(subtree, tvb, pinfo, pOffset, "DiagnosticInfos", "DiagnosticInfo", parseDiagnosticInfo, ett_opcua_array_DiagnosticInfo);
  proto_item_set_end(ti, tvb, *pOffset);
}
void parseHistoryReadRequest(proto_tree *tree, tvbuff_t *tvb, packet_info *pinfo, int *pOffset)
{
  proto_item *ti;
  proto_tree *subtree = proto_tree_add_subtree(tree, tvb, *pOffset, -1, ett_opcua_HistoryReadRequest, &ti, "HistoryReadRequest");

  parseRequestHeader(subtree, tvb, pinfo, pOffset, "RequestHeader");
  parseExtensionObject(subtree, tvb, pinfo, pOffset, "HistoryReadDetails");
  parseTimestampsToReturn(subtree, tvb, pinfo, pOffset);
  parseBoolean(subtree, tvb, pinfo, pOffset, hf_opcua_ReleaseContinuationPoints);
  /* Array length field ignored: NoOfNodesToRead */
  parseArrayComplex(subtree, tvb, pinfo, pOffset, "NodesToRead", "HistoryReadValueId", parseHistoryReadValueId, ett_opcua_array_HistoryReadValueId);
  proto_item_set_end(ti, tvb, *pOffset);
}
void parseHistoryReadResponse(proto_tree *tree, tvbuff_t *tvb, packet_info *pinfo, int *pOffset)
{
  proto_item *ti;
  proto_tree *subtree = proto_tree_add_subtree(tree, tvb, *pOffset, -1, ett_opcua_HistoryReadResponse, &ti, "HistoryReadResponse");

  parseResponseHeader(subtree, tvb, pinfo, pOffset, "ResponseHeader");
  /* Array length field ignored: NoOfResults */
  parseArrayComplex(subtree, tvb, pinfo, pOffset, "Results", "HistoryReadResult", parseHistoryReadResult, ett_opcua_array_HistoryReadResult);
  /* Array length field ignored: NoOfDiagnosticInfos */
  parseArrayComplex(subtree, tvb, pinfo, pOffset, "DiagnosticInfos", "DiagnosticInfo", parseDiagnosticInfo, ett_opcua_array_DiagnosticInfo);
  proto_item_set_end(ti, tvb, *pOffset);
}
void parseWriteRequest(proto_tree *tree, tvbuff_t *tvb, packet_info *pinfo, int *pOffset)
{
  proto_item *ti;
  proto_tree *subtree = proto_tree_add_subtree(tree, tvb, *pOffset, -1, ett_opcua_WriteRequest, &ti, "WriteRequest");

  parseRequestHeader(subtree, tvb, pinfo, pOffset, "RequestHeader");
  /* Array length field ignored: NoOfNodesToWrite */
  parseArrayComplex(subtree, tvb, pinfo, pOffset, "NodesToWrite", "WriteValue", parseWriteValue, ett_opcua_array_WriteValue);
  proto_item_set_end(ti, tvb, *pOffset);
}
void parseWriteResponse(proto_tree *tree, tvbuff_t *tvb, packet_info *pinfo, int *pOffset)
{
  proto_item *ti;
  proto_tree *subtree = proto_tree_add_subtree(tree, tvb, *pOffset, -1, ett_opcua_WriteResponse, &ti, "WriteResponse");

  parseResponseHeader(subtree, tvb, pinfo, pOffset, "ResponseHeader");
  /* Array length field ignored: NoOfResults */
  parseArraySimple(subtree, tvb, pinfo, pOffset, "Results", "StatusCode", hf_opcua_Results, parseStatusCode, ett_opcua_array_StatusCode);
  /* Array length field ignored: NoOfDiagnosticInfos */
  parseArrayComplex(subtree, tvb, pinfo, pOffset, "DiagnosticInfos", "DiagnosticInfo", parseDiagnosticInfo, ett_opcua_array_DiagnosticInfo);
  proto_item_set_end(ti, tvb, *pOffset);
}
void parseHistoryUpdateRequest(proto_tree *tree, tvbuff_t *tvb, packet_info *pinfo, int *pOffset)
{
  proto_item *ti;
  proto_tree *subtree = proto_tree_add_subtree(tree, tvb, *pOffset, -1, ett_opcua_HistoryUpdateRequest, &ti, "HistoryUpdateRequest");

  parseRequestHeader(subtree, tvb, pinfo, pOffset, "RequestHeader");
  /* Array length field ignored: NoOfHistoryUpdateDetails */
  parseArrayComplex(subtree, tvb, pinfo, pOffset, "HistoryUpdateDetails", "ExtensionObject", parseExtensionObject, ett_opcua_array_ExtensionObject);
  proto_item_set_end(ti, tvb, *pOffset);
}
void parseHistoryUpdateResponse(proto_tree *tree, tvbuff_t *tvb, packet_info *pinfo, int *pOffset)
{
  proto_item *ti;
  proto_tree *subtree = proto_tree_add_subtree(tree, tvb, *pOffset, -1, ett_opcua_HistoryUpdateResponse, &ti, "HistoryUpdateResponse");

  parseResponseHeader(subtree, tvb, pinfo, pOffset, "ResponseHeader");
  /* Array length field ignored: NoOfResults */
  parseArrayComplex(subtree, tvb, pinfo, pOffset, "Results", "HistoryUpdateResult", parseHistoryUpdateResult, ett_opcua_array_HistoryUpdateResult);
  /* Array length field ignored: NoOfDiagnosticInfos */
  parseArrayComplex(subtree, tvb, pinfo, pOffset, "DiagnosticInfos", "DiagnosticInfo", parseDiagnosticInfo, ett_opcua_array_DiagnosticInfo);
  proto_item_set_end(ti, tvb, *pOffset);
}
void parseCallRequest(proto_tree *tree, tvbuff_t *tvb, packet_info *pinfo, int *pOffset)
{
  proto_item *ti;
  proto_tree *subtree = proto_tree_add_subtree(tree, tvb, *pOffset, -1, ett_opcua_CallRequest, &ti, "CallRequest");

  parseRequestHeader(subtree, tvb, pinfo, pOffset, "RequestHeader");
  /* Array length field ignored: NoOfMethodsToCall */
  parseArrayComplex(subtree, tvb, pinfo, pOffset, "MethodsToCall", "CallMethodRequest", parseCallMethodRequest, ett_opcua_array_CallMethodRequest);
  proto_item_set_end(ti, tvb, *pOffset);
}
void parseCallResponse(proto_tree *tree, tvbuff_t *tvb, packet_info *pinfo, int *pOffset)
{
  proto_item *ti;
  proto_tree *subtree = proto_tree_add_subtree(tree, tvb, *pOffset, -1, ett_opcua_CallResponse, &ti, "CallResponse");

  parseResponseHeader(subtree, tvb, pinfo, pOffset, "ResponseHeader");
  /* Array length field ignored: NoOfResults */
  parseArrayComplex(subtree, tvb, pinfo, pOffset, "Results", "CallMethodResult", parseCallMethodResult, ett_opcua_array_CallMethodResult);
  /* Array length field ignored: NoOfDiagnosticInfos */
  parseArrayComplex(subtree, tvb, pinfo, pOffset, "DiagnosticInfos", "DiagnosticInfo", parseDiagnosticInfo, ett_opcua_array_DiagnosticInfo);
  proto_item_set_end(ti, tvb, *pOffset);
}
void parseCreateMonitoredItemsRequest(proto_tree *tree, tvbuff_t *tvb, packet_info *pinfo, int *pOffset)
{
  proto_item *ti;
  proto_tree *subtree = proto_tree_add_subtree(tree, tvb, *pOffset, -1, ett_opcua_CreateMonitoredItemsRequest, &ti, "CreateMonitoredItemsRequest");

  parseRequestHeader(subtree, tvb, pinfo, pOffset, "RequestHeader");
  parseUInt32(subtree, tvb, pinfo, pOffset, hf_opcua_SubscriptionId);
  parseTimestampsToReturn(subtree, tvb, pinfo, pOffset);
  /* Array length field ignored: NoOfItemsToCreate */
  parseArrayComplex(subtree, tvb, pinfo, pOffset, "ItemsToCreate", "MonitoredItemCreateRequest", parseMonitoredItemCreateRequest, ett_opcua_array_MonitoredItemCreateRequest);
  proto_item_set_end(ti, tvb, *pOffset);
}
void parseCreateMonitoredItemsResponse(proto_tree *tree, tvbuff_t *tvb, packet_info *pinfo, int *pOffset)
{
  proto_item *ti;
  proto_tree *subtree = proto_tree_add_subtree(tree, tvb, *pOffset, -1, ett_opcua_CreateMonitoredItemsResponse, &ti, "CreateMonitoredItemsResponse");

  parseResponseHeader(subtree, tvb, pinfo, pOffset, "ResponseHeader");
  /* Array length field ignored: NoOfResults */
  parseArrayComplex(subtree, tvb, pinfo, pOffset, "Results", "MonitoredItemCreateResult", parseMonitoredItemCreateResult, ett_opcua_array_MonitoredItemCreateResult);
  /* Array length field ignored: NoOfDiagnosticInfos */
  parseArrayComplex(subtree, tvb, pinfo, pOffset, "DiagnosticInfos", "DiagnosticInfo", parseDiagnosticInfo, ett_opcua_array_DiagnosticInfo);
  proto_item_set_end(ti, tvb, *pOffset);
}
void parseModifyMonitoredItemsRequest(proto_tree *tree, tvbuff_t *tvb, packet_info *pinfo, int *pOffset)
{
  proto_item *ti;
  proto_tree *subtree = proto_tree_add_subtree(tree, tvb, *pOffset, -1, ett_opcua_ModifyMonitoredItemsRequest, &ti, "ModifyMonitoredItemsRequest");

  parseRequestHeader(subtree, tvb, pinfo, pOffset, "RequestHeader");
  parseUInt32(subtree, tvb, pinfo, pOffset, hf_opcua_SubscriptionId);
  parseTimestampsToReturn(subtree, tvb, pinfo, pOffset);
  /* Array length field ignored: NoOfItemsToModify */
  parseArrayComplex(subtree, tvb, pinfo, pOffset, "ItemsToModify", "MonitoredItemModifyRequest", parseMonitoredItemModifyRequest, ett_opcua_array_MonitoredItemModifyRequest);
  proto_item_set_end(ti, tvb, *pOffset);
}
void parseModifyMonitoredItemsResponse(proto_tree *tree, tvbuff_t *tvb, packet_info *pinfo, int *pOffset)
{
  proto_item *ti;
  proto_tree *subtree = proto_tree_add_subtree(tree, tvb, *pOffset, -1, ett_opcua_ModifyMonitoredItemsResponse, &ti, "ModifyMonitoredItemsResponse");

  parseResponseHeader(subtree, tvb, pinfo, pOffset, "ResponseHeader");
  /* Array length field ignored: NoOfResults */
  parseArrayComplex(subtree, tvb, pinfo, pOffset, "Results", "MonitoredItemModifyResult", parseMonitoredItemModifyResult, ett_opcua_array_MonitoredItemModifyResult);
  /* Array length field ignored: NoOfDiagnosticInfos */
  parseArrayComplex(subtree, tvb, pinfo, pOffset, "DiagnosticInfos", "DiagnosticInfo", parseDiagnosticInfo, ett_opcua_array_DiagnosticInfo);
  proto_item_set_end(ti, tvb, *pOffset);
}
void parseSetMonitoringModeRequest(proto_tree *tree, tvbuff_t *tvb, packet_info *pinfo, int *pOffset)
{
  proto_item *ti;
  proto_tree *subtree = proto_tree_add_subtree(tree, tvb, *pOffset, -1, ett_opcua_SetMonitoringModeRequest, &ti, "SetMonitoringModeRequest");

  parseRequestHeader(subtree, tvb, pinfo, pOffset, "RequestHeader");
  parseUInt32(subtree, tvb, pinfo, pOffset, hf_opcua_SubscriptionId);
  parseMonitoringMode(subtree, tvb, pinfo, pOffset);
  /* Array length field ignored: NoOfMonitoredItemIds */
  parseArraySimple(subtree, tvb, pinfo, pOffset, "MonitoredItemIds", "UInt32", hf_opcua_MonitoredItemIds, parseUInt32, ett_opcua_array_UInt32);
  proto_item_set_end(ti, tvb, *pOffset);
}
void parseSetMonitoringModeResponse(proto_tree *tree, tvbuff_t *tvb, packet_info *pinfo, int *pOffset)
{
  proto_item *ti;
  proto_tree *subtree = proto_tree_add_subtree(tree, tvb, *pOffset, -1, ett_opcua_SetMonitoringModeResponse, &ti, "SetMonitoringModeResponse");

  parseResponseHeader(subtree, tvb, pinfo, pOffset, "ResponseHeader");
  /* Array length field ignored: NoOfResults */
  parseArraySimple(subtree, tvb, pinfo, pOffset, "Results", "StatusCode", hf_opcua_Results, parseStatusCode, ett_opcua_array_StatusCode);
  /* Array length field ignored: NoOfDiagnosticInfos */
  parseArrayComplex(subtree, tvb, pinfo, pOffset, "DiagnosticInfos", "DiagnosticInfo", parseDiagnosticInfo, ett_opcua_array_DiagnosticInfo);
  proto_item_set_end(ti, tvb, *pOffset);
}
void parseSetTriggeringRequest(proto_tree *tree, tvbuff_t *tvb, packet_info *pinfo, int *pOffset)
{
  proto_item *ti;
  proto_tree *subtree = proto_tree_add_subtree(tree, tvb, *pOffset, -1, ett_opcua_SetTriggeringRequest, &ti, "SetTriggeringRequest");

  parseRequestHeader(subtree, tvb, pinfo, pOffset, "RequestHeader");
  parseUInt32(subtree, tvb, pinfo, pOffset, hf_opcua_SubscriptionId);
  parseUInt32(subtree, tvb, pinfo, pOffset, hf_opcua_TriggeringItemId);
  /* Array length field ignored: NoOfLinksToAdd */
  parseArraySimple(subtree, tvb, pinfo, pOffset, "LinksToAdd", "UInt32", hf_opcua_LinksToAdd, parseUInt32, ett_opcua_array_UInt32);
  /* Array length field ignored: NoOfLinksToRemove */
  parseArraySimple(subtree, tvb, pinfo, pOffset, "LinksToRemove", "UInt32", hf_opcua_LinksToRemove, parseUInt32, ett_opcua_array_UInt32);
  proto_item_set_end(ti, tvb, *pOffset);
}
void parseSetTriggeringResponse(proto_tree *tree, tvbuff_t *tvb, packet_info *pinfo, int *pOffset)
{
  proto_item *ti;
  proto_tree *subtree = proto_tree_add_subtree(tree, tvb, *pOffset, -1, ett_opcua_SetTriggeringResponse, &ti, "SetTriggeringResponse");

  parseResponseHeader(subtree, tvb, pinfo, pOffset, "ResponseHeader");
  /* Array length field ignored: NoOfAddResults */
  parseArraySimple(subtree, tvb, pinfo, pOffset, "AddResults", "StatusCode", hf_opcua_AddResults, parseStatusCode, ett_opcua_array_StatusCode);
  /* Array length field ignored: NoOfAddDiagnosticInfos */
  parseArrayComplex(subtree, tvb, pinfo, pOffset, "AddDiagnosticInfos", "DiagnosticInfo", parseDiagnosticInfo, ett_opcua_array_DiagnosticInfo);
  /* Array length field ignored: NoOfRemoveResults */
  parseArraySimple(subtree, tvb, pinfo, pOffset, "RemoveResults", "StatusCode", hf_opcua_RemoveResults, parseStatusCode, ett_opcua_array_StatusCode);
  /* Array length field ignored: NoOfRemoveDiagnosticInfos */
  parseArrayComplex(subtree, tvb, pinfo, pOffset, "RemoveDiagnosticInfos", "DiagnosticInfo", parseDiagnosticInfo, ett_opcua_array_DiagnosticInfo);
  proto_item_set_end(ti, tvb, *pOffset);
}
void parseDeleteMonitoredItemsRequest(proto_tree *tree, tvbuff_t *tvb, packet_info *pinfo, int *pOffset)
{
  proto_item *ti;
  proto_tree *subtree = proto_tree_add_subtree(tree, tvb, *pOffset, -1, ett_opcua_DeleteMonitoredItemsRequest, &ti, "DeleteMonitoredItemsRequest");

  parseRequestHeader(subtree, tvb, pinfo, pOffset, "RequestHeader");
  parseUInt32(subtree, tvb, pinfo, pOffset, hf_opcua_SubscriptionId);
  /* Array length field ignored: NoOfMonitoredItemIds */
  parseArraySimple(subtree, tvb, pinfo, pOffset, "MonitoredItemIds", "UInt32", hf_opcua_MonitoredItemIds, parseUInt32, ett_opcua_array_UInt32);
  proto_item_set_end(ti, tvb, *pOffset);
}
void parseDeleteMonitoredItemsResponse(proto_tree *tree, tvbuff_t *tvb, packet_info *pinfo, int *pOffset)
{
  proto_item *ti;
  proto_tree *subtree = proto_tree_add_subtree(tree, tvb, *pOffset, -1, ett_opcua_DeleteMonitoredItemsResponse, &ti, "DeleteMonitoredItemsResponse");

  parseResponseHeader(subtree, tvb, pinfo, pOffset, "ResponseHeader");
  /* Array length field ignored: NoOfResults */
  parseArraySimple(subtree, tvb, pinfo, pOffset, "Results", "StatusCode", hf_opcua_Results, parseStatusCode, ett_opcua_array_StatusCode);
  /* Array length field ignored: NoOfDiagnosticInfos */
  parseArrayComplex(subtree, tvb, pinfo, pOffset, "DiagnosticInfos", "DiagnosticInfo", parseDiagnosticInfo, ett_opcua_array_DiagnosticInfo);
  proto_item_set_end(ti, tvb, *pOffset);
}
void parseCreateSubscriptionRequest(proto_tree *tree, tvbuff_t *tvb, packet_info *pinfo, int *pOffset)
{
  proto_item *ti;
  proto_tree *subtree = proto_tree_add_subtree(tree, tvb, *pOffset, -1, ett_opcua_CreateSubscriptionRequest, &ti, "CreateSubscriptionRequest");

  parseRequestHeader(subtree, tvb, pinfo, pOffset, "RequestHeader");
  parseDouble(subtree, tvb, pinfo, pOffset, hf_opcua_RequestedPublishingInterval);
  parseUInt32(subtree, tvb, pinfo, pOffset, hf_opcua_RequestedLifetimeCount);
  parseUInt32(subtree, tvb, pinfo, pOffset, hf_opcua_RequestedMaxKeepAliveCount);
  parseUInt32(subtree, tvb, pinfo, pOffset, hf_opcua_MaxNotificationsPerPublish);
  parseBoolean(subtree, tvb, pinfo, pOffset, hf_opcua_PublishingEnabled);
  parseByte(subtree, tvb, pinfo, pOffset, hf_opcua_Priority);
  proto_item_set_end(ti, tvb, *pOffset);
}
void parseCreateSubscriptionResponse(proto_tree *tree, tvbuff_t *tvb, packet_info *pinfo, int *pOffset)
{
  proto_item *ti;
  proto_tree *subtree = proto_tree_add_subtree(tree, tvb, *pOffset, -1, ett_opcua_CreateSubscriptionResponse, &ti, "CreateSubscriptionResponse");

  parseResponseHeader(subtree, tvb, pinfo, pOffset, "ResponseHeader");
  parseUInt32(subtree, tvb, pinfo, pOffset, hf_opcua_SubscriptionId);
  parseDouble(subtree, tvb, pinfo, pOffset, hf_opcua_RevisedPublishingInterval);
  parseUInt32(subtree, tvb, pinfo, pOffset, hf_opcua_RevisedLifetimeCount);
  parseUInt32(subtree, tvb, pinfo, pOffset, hf_opcua_RevisedMaxKeepAliveCount);
  proto_item_set_end(ti, tvb, *pOffset);
}
void parseModifySubscriptionRequest(proto_tree *tree, tvbuff_t *tvb, packet_info *pinfo, int *pOffset)
{
  proto_item *ti;
  proto_tree *subtree = proto_tree_add_subtree(tree, tvb, *pOffset, -1, ett_opcua_ModifySubscriptionRequest, &ti, "ModifySubscriptionRequest");

  parseRequestHeader(subtree, tvb, pinfo, pOffset, "RequestHeader");
  parseUInt32(subtree, tvb, pinfo, pOffset, hf_opcua_SubscriptionId);
  parseDouble(subtree, tvb, pinfo, pOffset, hf_opcua_RequestedPublishingInterval);
  parseUInt32(subtree, tvb, pinfo, pOffset, hf_opcua_RequestedLifetimeCount);
  parseUInt32(subtree, tvb, pinfo, pOffset, hf_opcua_RequestedMaxKeepAliveCount);
  parseUInt32(subtree, tvb, pinfo, pOffset, hf_opcua_MaxNotificationsPerPublish);
  parseByte(subtree, tvb, pinfo, pOffset, hf_opcua_Priority);
  proto_item_set_end(ti, tvb, *pOffset);
}
void parseModifySubscriptionResponse(proto_tree *tree, tvbuff_t *tvb, packet_info *pinfo, int *pOffset)
{
  proto_item *ti;
  proto_tree *subtree = proto_tree_add_subtree(tree, tvb, *pOffset, -1, ett_opcua_ModifySubscriptionResponse, &ti, "ModifySubscriptionResponse");

  parseResponseHeader(subtree, tvb, pinfo, pOffset, "ResponseHeader");
  parseDouble(subtree, tvb, pinfo, pOffset, hf_opcua_RevisedPublishingInterval);
  parseUInt32(subtree, tvb, pinfo, pOffset, hf_opcua_RevisedLifetimeCount);
  parseUInt32(subtree, tvb, pinfo, pOffset, hf_opcua_RevisedMaxKeepAliveCount);
  proto_item_set_end(ti, tvb, *pOffset);
}
void parseSetPublishingModeRequest(proto_tree *tree, tvbuff_t *tvb, packet_info *pinfo, int *pOffset)
{
  proto_item *ti;
  proto_tree *subtree = proto_tree_add_subtree(tree, tvb, *pOffset, -1, ett_opcua_SetPublishingModeRequest, &ti, "SetPublishingModeRequest");

  parseRequestHeader(subtree, tvb, pinfo, pOffset, "RequestHeader");
  parseBoolean(subtree, tvb, pinfo, pOffset, hf_opcua_PublishingEnabled);
  /* Array length field ignored: NoOfSubscriptionIds */
  parseArraySimple(subtree, tvb, pinfo, pOffset, "SubscriptionIds", "UInt32", hf_opcua_SubscriptionIds, parseUInt32, ett_opcua_array_UInt32);
  proto_item_set_end(ti, tvb, *pOffset);
}
void parseSetPublishingModeResponse(proto_tree *tree, tvbuff_t *tvb, packet_info *pinfo, int *pOffset)
{
  proto_item *ti;
  proto_tree *subtree = proto_tree_add_subtree(tree, tvb, *pOffset, -1, ett_opcua_SetPublishingModeResponse, &ti, "SetPublishingModeResponse");

  parseResponseHeader(subtree, tvb, pinfo, pOffset, "ResponseHeader");
  /* Array length field ignored: NoOfResults */
  parseArraySimple(subtree, tvb, pinfo, pOffset, "Results", "StatusCode", hf_opcua_Results, parseStatusCode, ett_opcua_array_StatusCode);
  /* Array length field ignored: NoOfDiagnosticInfos */
  parseArrayComplex(subtree, tvb, pinfo, pOffset, "DiagnosticInfos", "DiagnosticInfo", parseDiagnosticInfo, ett_opcua_array_DiagnosticInfo);
  proto_item_set_end(ti, tvb, *pOffset);
}
void parsePublishRequest(proto_tree *tree, tvbuff_t *tvb, packet_info *pinfo, int *pOffset)
{
  proto_item *ti;
  proto_tree *subtree = proto_tree_add_subtree(tree, tvb, *pOffset, -1, ett_opcua_PublishRequest, &ti, "PublishRequest");

  parseRequestHeader(subtree, tvb, pinfo, pOffset, "RequestHeader");
  /* Array length field ignored: NoOfSubscriptionAcknowledgements */
  parseArrayComplex(subtree, tvb, pinfo, pOffset, "SubscriptionAcknowledgements", "SubscriptionAcknowledgement", parseSubscriptionAcknowledgement, ett_opcua_array_SubscriptionAcknowledgement);
  proto_item_set_end(ti, tvb, *pOffset);
}
void parsePublishResponse(proto_tree *tree, tvbuff_t *tvb, packet_info *pinfo, int *pOffset)
{
  proto_item *ti;
  proto_tree *subtree = proto_tree_add_subtree(tree, tvb, *pOffset, -1, ett_opcua_PublishResponse, &ti, "PublishResponse");

  parseResponseHeader(subtree, tvb, pinfo, pOffset, "ResponseHeader");
  parseUInt32(subtree, tvb, pinfo, pOffset, hf_opcua_SubscriptionId);
  /* Array length field ignored: NoOfAvailableSequenceNumbers */
  parseArraySimple(subtree, tvb, pinfo, pOffset, "AvailableSequenceNumbers", "UInt32", hf_opcua_AvailableSequenceNumbers, parseUInt32, ett_opcua_array_UInt32);
  parseBoolean(subtree, tvb, pinfo, pOffset, hf_opcua_MoreNotifications);
  parseNotificationMessage(subtree, tvb, pinfo, pOffset, "NotificationMessage");
  /* Array length field ignored: NoOfResults */
  parseArraySimple(subtree, tvb, pinfo, pOffset, "Results", "StatusCode", hf_opcua_Results, parseStatusCode, ett_opcua_array_StatusCode);
  /* Array length field ignored: NoOfDiagnosticInfos */
  parseArrayComplex(subtree, tvb, pinfo, pOffset, "DiagnosticInfos", "DiagnosticInfo", parseDiagnosticInfo, ett_opcua_array_DiagnosticInfo);
  proto_item_set_end(ti, tvb, *pOffset);
}
void parseRepublishRequest(proto_tree *tree, tvbuff_t *tvb, packet_info *pinfo, int *pOffset)
{
  proto_item *ti;
  proto_tree *subtree = proto_tree_add_subtree(tree, tvb, *pOffset, -1, ett_opcua_RepublishRequest, &ti, "RepublishRequest");

  parseRequestHeader(subtree, tvb, pinfo, pOffset, "RequestHeader");
  parseUInt32(subtree, tvb, pinfo, pOffset, hf_opcua_SubscriptionId);
  parseUInt32(subtree, tvb, pinfo, pOffset, hf_opcua_RetransmitSequenceNumber);
  proto_item_set_end(ti, tvb, *pOffset);
}
void parseRepublishResponse(proto_tree *tree, tvbuff_t *tvb, packet_info *pinfo, int *pOffset)
{
  proto_item *ti;
  proto_tree *subtree = proto_tree_add_subtree(tree, tvb, *pOffset, -1, ett_opcua_RepublishResponse, &ti, "RepublishResponse");

  parseResponseHeader(subtree, tvb, pinfo, pOffset, "ResponseHeader");
  parseNotificationMessage(subtree, tvb, pinfo, pOffset, "NotificationMessage");
  proto_item_set_end(ti, tvb, *pOffset);
}
void parseTransferSubscriptionsRequest(proto_tree *tree, tvbuff_t *tvb, packet_info *pinfo, int *pOffset)
{
  proto_item *ti;
  proto_tree *subtree = proto_tree_add_subtree(tree, tvb, *pOffset, -1, ett_opcua_TransferSubscriptionsRequest, &ti, "TransferSubscriptionsRequest");

  parseRequestHeader(subtree, tvb, pinfo, pOffset, "RequestHeader");
  /* Array length field ignored: NoOfSubscriptionIds */
  parseArraySimple(subtree, tvb, pinfo, pOffset, "SubscriptionIds", "UInt32", hf_opcua_SubscriptionIds, parseUInt32, ett_opcua_array_UInt32);
  parseBoolean(subtree, tvb, pinfo, pOffset, hf_opcua_SendInitialValues);
  proto_item_set_end(ti, tvb, *pOffset);
}
void parseTransferSubscriptionsResponse(proto_tree *tree, tvbuff_t *tvb, packet_info *pinfo, int *pOffset)
{
  proto_item *ti;
  proto_tree *subtree = proto_tree_add_subtree(tree, tvb, *pOffset, -1, ett_opcua_TransferSubscriptionsResponse, &ti, "TransferSubscriptionsResponse");

  parseResponseHeader(subtree, tvb, pinfo, pOffset, "ResponseHeader");
  /* Array length field ignored: NoOfResults */
  parseArrayComplex(subtree, tvb, pinfo, pOffset, "Results", "TransferResult", parseTransferResult, ett_opcua_array_TransferResult);
  /* Array length field ignored: NoOfDiagnosticInfos */
  parseArrayComplex(subtree, tvb, pinfo, pOffset, "DiagnosticInfos", "DiagnosticInfo", parseDiagnosticInfo, ett_opcua_array_DiagnosticInfo);
  proto_item_set_end(ti, tvb, *pOffset);
}
void parseDeleteSubscriptionsRequest(proto_tree *tree, tvbuff_t *tvb, packet_info *pinfo, int *pOffset)
{
  proto_item *ti;
  proto_tree *subtree = proto_tree_add_subtree(tree, tvb, *pOffset, -1, ett_opcua_DeleteSubscriptionsRequest, &ti, "DeleteSubscriptionsRequest");

  parseRequestHeader(subtree, tvb, pinfo, pOffset, "RequestHeader");
  /* Array length field ignored: NoOfSubscriptionIds */
  parseArraySimple(subtree, tvb, pinfo, pOffset, "SubscriptionIds", "UInt32", hf_opcua_SubscriptionIds, parseUInt32, ett_opcua_array_UInt32);
  proto_item_set_end(ti, tvb, *pOffset);
}
void parseDeleteSubscriptionsResponse(proto_tree *tree, tvbuff_t *tvb, packet_info *pinfo, int *pOffset)
{
  proto_item *ti;
  proto_tree *subtree = proto_tree_add_subtree(tree, tvb, *pOffset, -1, ett_opcua_DeleteSubscriptionsResponse, &ti, "DeleteSubscriptionsResponse");

  parseResponseHeader(subtree, tvb, pinfo, pOffset, "ResponseHeader");
  /* Array length field ignored: NoOfResults */
  parseArraySimple(subtree, tvb, pinfo, pOffset, "Results", "StatusCode", hf_opcua_Results, parseStatusCode, ett_opcua_array_StatusCode);
  /* Array length field ignored: NoOfDiagnosticInfos */
  parseArrayComplex(subtree, tvb, pinfo, pOffset, "DiagnosticInfos", "DiagnosticInfo", parseDiagnosticInfo, ett_opcua_array_DiagnosticInfo);
  proto_item_set_end(ti, tvb, *pOffset);
}
void parseTestStackRequest(proto_tree *tree, tvbuff_t *tvb, packet_info *pinfo, int *pOffset)
{
  proto_item *ti;
  proto_tree *subtree = proto_tree_add_subtree(tree, tvb, *pOffset, -1, ett_opcua_TestStackRequest, &ti, "TestStackRequest");

  parseRequestHeader(subtree, tvb, pinfo, pOffset, "RequestHeader");
  parseUInt32(subtree, tvb, pinfo, pOffset, hf_opcua_TestId);
  parseInt32(subtree, tvb, pinfo, pOffset, hf_opcua_Iteration);
  parseVariant(subtree, tvb, pinfo, pOffset, "Input");
  proto_item_set_end(ti, tvb, *pOffset);
}
void parseTestStackResponse(proto_tree *tree, tvbuff_t *tvb, packet_info *pinfo, int *pOffset)
{
  proto_item *ti;
  proto_tree *subtree = proto_tree_add_subtree(tree, tvb, *pOffset, -1, ett_opcua_TestStackResponse, &ti, "TestStackResponse");

  parseResponseHeader(subtree, tvb, pinfo, pOffset, "ResponseHeader");
  parseVariant(subtree, tvb, pinfo, pOffset, "Output");
  proto_item_set_end(ti, tvb, *pOffset);
}
void parseTestStackExRequest(proto_tree *tree, tvbuff_t *tvb, packet_info *pinfo, int *pOffset)
{
  proto_item *ti;
  proto_tree *subtree = proto_tree_add_subtree(tree, tvb, *pOffset, -1, ett_opcua_TestStackExRequest, &ti, "TestStackExRequest");

  parseRequestHeader(subtree, tvb, pinfo, pOffset, "RequestHeader");
  parseUInt32(subtree, tvb, pinfo, pOffset, hf_opcua_TestId);
  parseInt32(subtree, tvb, pinfo, pOffset, hf_opcua_Iteration);
  parseCompositeTestType(subtree, tvb, pinfo, pOffset, "Input");
  proto_item_set_end(ti, tvb, *pOffset);
}
void parseTestStackExResponse(proto_tree *tree, tvbuff_t *tvb, packet_info *pinfo, int *pOffset)
{
  proto_item *ti;
  proto_tree *subtree = proto_tree_add_subtree(tree, tvb, *pOffset, -1, ett_opcua_TestStackExResponse, &ti, "TestStackExResponse");

  parseResponseHeader(subtree, tvb, pinfo, pOffset, "ResponseHeader");
  parseCompositeTestType(subtree, tvb, pinfo, pOffset, "Output");
  proto_item_set_end(ti, tvb, *pOffset);
}

/** Setup protocol subtree array */
static int *ett[] =
{
  &ett_opcua_ServiceFault,
  &ett_opcua_array_ServiceFault,
  &ett_opcua_FindServersRequest,
  &ett_opcua_array_FindServersRequest,
  &ett_opcua_FindServersResponse,
  &ett_opcua_array_FindServersResponse,
  &ett_opcua_FindServersOnNetworkRequest,
  &ett_opcua_array_FindServersOnNetworkRequest,
  &ett_opcua_FindServersOnNetworkResponse,
  &ett_opcua_array_FindServersOnNetworkResponse,
  &ett_opcua_GetEndpointsRequest,
  &ett_opcua_array_GetEndpointsRequest,
  &ett_opcua_GetEndpointsResponse,
  &ett_opcua_array_GetEndpointsResponse,
  &ett_opcua_RegisterServerRequest,
  &ett_opcua_array_RegisterServerRequest,
  &ett_opcua_RegisterServerResponse,
  &ett_opcua_array_RegisterServerResponse,
  &ett_opcua_RegisterServer2Request,
  &ett_opcua_array_RegisterServer2Request,
  &ett_opcua_RegisterServer2Response,
  &ett_opcua_array_RegisterServer2Response,
  &ett_opcua_OpenSecureChannelRequest,
  &ett_opcua_array_OpenSecureChannelRequest,
  &ett_opcua_OpenSecureChannelResponse,
  &ett_opcua_array_OpenSecureChannelResponse,
  &ett_opcua_CloseSecureChannelRequest,
  &ett_opcua_array_CloseSecureChannelRequest,
  &ett_opcua_CloseSecureChannelResponse,
  &ett_opcua_array_CloseSecureChannelResponse,
  &ett_opcua_CreateSessionRequest,
  &ett_opcua_array_CreateSessionRequest,
  &ett_opcua_CreateSessionResponse,
  &ett_opcua_array_CreateSessionResponse,
  &ett_opcua_ActivateSessionRequest,
  &ett_opcua_array_ActivateSessionRequest,
  &ett_opcua_ActivateSessionResponse,
  &ett_opcua_array_ActivateSessionResponse,
  &ett_opcua_CloseSessionRequest,
  &ett_opcua_array_CloseSessionRequest,
  &ett_opcua_CloseSessionResponse,
  &ett_opcua_array_CloseSessionResponse,
  &ett_opcua_CancelRequest,
  &ett_opcua_array_CancelRequest,
  &ett_opcua_CancelResponse,
  &ett_opcua_array_CancelResponse,
  &ett_opcua_AddNodesRequest,
  &ett_opcua_array_AddNodesRequest,
  &ett_opcua_AddNodesResponse,
  &ett_opcua_array_AddNodesResponse,
  &ett_opcua_AddReferencesRequest,
  &ett_opcua_array_AddReferencesRequest,
  &ett_opcua_AddReferencesResponse,
  &ett_opcua_array_AddReferencesResponse,
  &ett_opcua_DeleteNodesRequest,
  &ett_opcua_array_DeleteNodesRequest,
  &ett_opcua_DeleteNodesResponse,
  &ett_opcua_array_DeleteNodesResponse,
  &ett_opcua_DeleteReferencesRequest,
  &ett_opcua_array_DeleteReferencesRequest,
  &ett_opcua_DeleteReferencesResponse,
  &ett_opcua_array_DeleteReferencesResponse,
  &ett_opcua_BrowseRequest,
  &ett_opcua_array_BrowseRequest,
  &ett_opcua_BrowseResponse,
  &ett_opcua_array_BrowseResponse,
  &ett_opcua_BrowseNextRequest,
  &ett_opcua_array_BrowseNextRequest,
  &ett_opcua_BrowseNextResponse,
  &ett_opcua_array_BrowseNextResponse,
  &ett_opcua_TranslateBrowsePathsToNodeIdsRequest,
  &ett_opcua_array_TranslateBrowsePathsToNodeIdsRequest,
  &ett_opcua_TranslateBrowsePathsToNodeIdsResponse,
  &ett_opcua_array_TranslateBrowsePathsToNodeIdsResponse,
  &ett_opcua_RegisterNodesRequest,
  &ett_opcua_array_RegisterNodesRequest,
  &ett_opcua_RegisterNodesResponse,
  &ett_opcua_array_RegisterNodesResponse,
  &ett_opcua_UnregisterNodesRequest,
  &ett_opcua_array_UnregisterNodesRequest,
  &ett_opcua_UnregisterNodesResponse,
  &ett_opcua_array_UnregisterNodesResponse,
  &ett_opcua_QueryFirstRequest,
  &ett_opcua_array_QueryFirstRequest,
  &ett_opcua_QueryFirstResponse,
  &ett_opcua_array_QueryFirstResponse,
  &ett_opcua_QueryNextRequest,
  &ett_opcua_array_QueryNextRequest,
  &ett_opcua_QueryNextResponse,
  &ett_opcua_array_QueryNextResponse,
  &ett_opcua_ReadRequest,
  &ett_opcua_array_ReadRequest,
  &ett_opcua_ReadResponse,
  &ett_opcua_array_ReadResponse,
  &ett_opcua_HistoryReadRequest,
  &ett_opcua_array_HistoryReadRequest,
  &ett_opcua_HistoryReadResponse,
  &ett_opcua_array_HistoryReadResponse,
  &ett_opcua_WriteRequest,
  &ett_opcua_array_WriteRequest,
  &ett_opcua_WriteResponse,
  &ett_opcua_array_WriteResponse,
  &ett_opcua_HistoryUpdateRequest,
  &ett_opcua_array_HistoryUpdateRequest,
  &ett_opcua_HistoryUpdateResponse,
  &ett_opcua_array_HistoryUpdateResponse,
  &ett_opcua_CallRequest,
  &ett_opcua_array_CallRequest,
  &ett_opcua_CallResponse,
  &ett_opcua_array_CallResponse,
  &ett_opcua_CreateMonitoredItemsRequest,
  &ett_opcua_array_CreateMonitoredItemsRequest,
  &ett_opcua_CreateMonitoredItemsResponse,
  &ett_opcua_array_CreateMonitoredItemsResponse,
  &ett_opcua_ModifyMonitoredItemsRequest,
  &ett_opcua_array_ModifyMonitoredItemsRequest,
  &ett_opcua_ModifyMonitoredItemsResponse,
  &ett_opcua_array_ModifyMonitoredItemsResponse,
  &ett_opcua_SetMonitoringModeRequest,
  &ett_opcua_array_SetMonitoringModeRequest,
  &ett_opcua_SetMonitoringModeResponse,
  &ett_opcua_array_SetMonitoringModeResponse,
  &ett_opcua_SetTriggeringRequest,
  &ett_opcua_array_SetTriggeringRequest,
  &ett_opcua_SetTriggeringResponse,
  &ett_opcua_array_SetTriggeringResponse,
  &ett_opcua_DeleteMonitoredItemsRequest,
  &ett_opcua_array_DeleteMonitoredItemsRequest,
  &ett_opcua_DeleteMonitoredItemsResponse,
  &ett_opcua_array_DeleteMonitoredItemsResponse,
  &ett_opcua_CreateSubscriptionRequest,
  &ett_opcua_array_CreateSubscriptionRequest,
  &ett_opcua_CreateSubscriptionResponse,
  &ett_opcua_array_CreateSubscriptionResponse,
  &ett_opcua_ModifySubscriptionRequest,
  &ett_opcua_array_ModifySubscriptionRequest,
  &ett_opcua_ModifySubscriptionResponse,
  &ett_opcua_array_ModifySubscriptionResponse,
  &ett_opcua_SetPublishingModeRequest,
  &ett_opcua_array_SetPublishingModeRequest,
  &ett_opcua_SetPublishingModeResponse,
  &ett_opcua_array_SetPublishingModeResponse,
  &ett_opcua_PublishRequest,
  &ett_opcua_array_PublishRequest,
  &ett_opcua_PublishResponse,
  &ett_opcua_array_PublishResponse,
  &ett_opcua_RepublishRequest,
  &ett_opcua_array_RepublishRequest,
  &ett_opcua_RepublishResponse,
  &ett_opcua_array_RepublishResponse,
  &ett_opcua_TransferSubscriptionsRequest,
  &ett_opcua_array_TransferSubscriptionsRequest,
  &ett_opcua_TransferSubscriptionsResponse,
  &ett_opcua_array_TransferSubscriptionsResponse,
  &ett_opcua_DeleteSubscriptionsRequest,
  &ett_opcua_array_DeleteSubscriptionsRequest,
  &ett_opcua_DeleteSubscriptionsResponse,
  &ett_opcua_array_DeleteSubscriptionsResponse,
  &ett_opcua_TestStackRequest,
  &ett_opcua_array_TestStackRequest,
  &ett_opcua_TestStackResponse,
  &ett_opcua_array_TestStackResponse,
  &ett_opcua_TestStackExRequest,
  &ett_opcua_array_TestStackExRequest,
  &ett_opcua_TestStackExResponse,
  &ett_opcua_array_TestStackExResponse,
};

void registerServiceTypes(void)
{
  proto_register_subtree_array(ett, array_length(ett));
}

